//
//  MyGlobalTimer.swift
//  HCSStudies
//
//  Created by Marvin Kowalewski on 23.07.23.
//
import Foundation

class TimerManager {
    static let shared = TimerManager()
    private var time_AfterLogin: Timer?
    private var startTime_AfterLogin: Date?
    private(set) var elapsedTime1: TimeInterval = 0.0
    
    private var time_NewTransaction: Timer?
    private var startTime_NewTransaction: Date?
    private(set) var elapsedTime2: TimeInterval = 0.0

    private init() {}

    func startTimer_AfterLogin() {
        if time_AfterLogin == nil {
            startTime_AfterLogin = Date()
            time_AfterLogin = Timer.scheduledTimer(timeInterval: 1.0, target: self, selector: #selector(updateElapsedTime1), userInfo: nil, repeats: true)
        }
    }

    func stopTimer_AfterLogin() {
        time_AfterLogin?.invalidate()
        time_AfterLogin = nil
        updateElapsedTime1()
    }
    
    func resetTimer_AfterLogin() {
        startTime_AfterLogin = nil
        elapsedTime1 = 0.0
    }
    
    func getElapsedTime1AsString_AfterLogin() -> String {
        return String(format: "%.0f", elapsedTime1)
    }
        

    func startTimer_NewTransaction() {
        if time_NewTransaction == nil {
            startTime_NewTransaction = Date()
            time_NewTransaction = Timer.scheduledTimer(timeInterval: 1.0, target: self, selector: #selector(updateElapsedTime2), userInfo: nil, repeats: true)
        }
    }

    func stopTimer_NewTransaction() {
        time_NewTransaction?.invalidate()
        time_NewTransaction = nil
        updateElapsedTime2()
    }
    
    func resetTimer_NewTransaction() {
        startTime_NewTransaction = nil
        elapsedTime2 = 0.0
    }
    
    func getElapsedTime2AsString_NewTransaction() -> String {
        return String(format: "%.0f", elapsedTime2)
    }
    

    @objc private func updateElapsedTime1() {
        if let startTime_AfterLogin = startTime_AfterLogin {
            elapsedTime1 = Date().timeIntervalSince(startTime_AfterLogin)
        }
    }
    
    @objc private func updateElapsedTime2() {
        if let startTime_NewTransaction = startTime_NewTransaction {
            elapsedTime2 = Date().timeIntervalSince(startTime_NewTransaction)
        }
    }
}
